--------------------------------------------------------------------
--            SymCACP Script Module Find End Validate
-- Symmetrical CA Control Panel   symCACPscript-1
--file for finding end generation (script2 version)
-- This version just checks a file of data
--------------------------------------------------------------------
--  P. Rendell  16/06/2023
--------------------------------------------------------------------

--
-- output 
-- RULE, WD, HT, SEED, GEO, GEN, RUNLEN


------------------------------------------------------------

local scriptType = "script2-findEnd"
local m={}			-- class table
m.cnt = 0
m.noLines = 0
m.noDiffs = 0
m.noMaxEx = 0

local comProcs			-- common Procedures
local logFile
local g = golly()
local scriptFileData
local gr = require("buildUni") 
local gs = require("search") 
m.colonList = {}
m.equalList = {['LOGFILE'] = {'t',""}, ['RESULTS_OLD'] = {'t',"R"}, ['RESULTS_NEW'] = {'t',""},
               ['endGen'] = {"d","R"}, ['MAX_OSC'] = {"d","R"}, ['MIN_OSC'] = {"d","R"},
               ['MAX_GEN'] = {'d',"R"},
               ['CHECK_MAX_GEN'] = {'l',"R"} }

------------------------------------------------------------------------------------------------


--==============================================================================
------------------------------------------------------------------------------------------------

function m.init(lf, cp)
   scriptFileData = {}
   comProcs = cp
   logFile = lf
end

------------------------------------------------------------------------------------------------
function m.buildParmVal(cmd, value, segNo)
   if (scriptFileData[cmd]) then
      comProcs.report.collect("Previous value overwriten "..cmd.." = "..value.."\n",true, segNo)
   end
   scriptFileData[cmd] = value
end

------------------------------------------------------------------------------------------------
function m.buildParmLst(cmd, parms, segNo)
   if (not scriptFileData[cmd]) then
      scriptFileData[cmd] = {}
   end
   for i, parm in pairs(parms) do
      table.insert(scriptFileData[cmd],parm)
   end
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   if not scriptFileData.HIGHT then
      scriptFileData.HIGHT = scriptFileData.WIDTH
   end
   if not scriptFileData.GEO then
      scriptFileData.GEO = {"R"}
   end
   return true
end



--==============================================================================

   local function doFINDpopRes(outFile, rule, geo, wv, hv, seed, gen, oscPeriod, pop, res)
      outFile:write(string.format("%s,%s,%s,%s,%s,%s,%s,%i,%s\n",
                                   rule, geo:sub(1,2), wv, hv, seed, gen, oscPeriod, pop, res))
   end
--------------------------------------------------------------------------------
--		OLD file to NEW file, check what is alredy in NEW file   , ignore repeated lines, header lines and any in dataOld
   function LoadFileData(infileName, logFile, dataOLD, dataNEW, text)
      local res = true
      local numLines = 0
      logFile:write(text..'\n')
      inFile = io.open ( infileName , "r")
      if inFile then
         local line = inFile:read("*l")
         while line do
            words = split(line)
            if #words == 9 then
               key = words[1]..':'..words[2]..':'..words[3]..':'..words[4]..':'..words[5]
               if  ( not dataOLD[key] and (words[1] ~= 'RULE') and not dataNEW[key]) then
                  dataNEW[key] = {words[6],words[7],words[8],words[9]}	-- gen, period, pop, type
                  numLines = numLines + 1
               end
            else
               logFile:write('***LoadFileData: line '..line..' not 9 words\n')
               res = false
            end
            line = inFile:read("*l")
         end 
         logFile:write('LoadFileData: data collected '..numLines..'\n')
         inFile:close()
      else
         logFile:write('***LoadFileData: File '..infileName..' not opened Missing?\n')
         res = false
      end
      logFile:write('LoadFileData: File '..infileName.." "..numLines..' Read, '..#dataNEW..' lines to process\n')
      m.noLines = numLines
      return(res)
   end
--------------------------------------------------------------------------------
--		OLD file to NEW file, check what is alredy in NEW file   
   function openOutFile()
      local res = false
      local words = {}
      local key
      local inFile
      local test = true
      m.linesDone = {}
      m.linesNotDone = {}
      if scriptFileData then
         if (   LoadFileData(scriptFileData.RESULTS_NEW, logFile, m.linesNotDone, m.linesDone,    'open NEW File to read data aready there')) then
            if (LoadFileData(scriptFileData.RESULTS_OLD, logFile, m.linesDone,   m.linesNotDone, 'open OLD File to read data to Process')) then
               m.outFile = io.open ( scriptFileData.RESULTS_NEW , "a")
               if m.outFile then
                  res = true
               else
                  logFile:write("***openOutFile: Output file not open"..scriptFileData.RESULTS_NEW.."\n")
               end
            end
         end  
       else
          logFile:write("***openOutFile: no scriptFileData\n")
       end  
      return (res)
   end
------------------------------------------------------------

local function divertLog()
   res = true
   local log = io.open ( scriptFileData.LOGFILE , "w")
   if log then
      logFile:write('Diverting to logfile '..scriptFileData.LOGFILE..'\n')
      logDiverted = true
      logFile:close()
      logFile = log
      log = nil
      comProcs.newLog(logFile)
   else
      logFile:write('Failed to divert to logfile '..scriptFileData.LOGFILE..'\n')
      res = false
   end
   return res
end
------------------------------------------------------------

local function reDivertLog()
   if logDiverted then
      logFile:close()
      logFile = comProcs.oldLog()
      logFile:write('Continue after log diversion\n')
   end
   logDiverted = false
end
------------------------------------------------------------

function m.run(segmentNo)
--------------------------------------------------------------------------
   logFile:write('\ndoFINDEND-n\n')
   local test =true
   local logDiverted
   local res = "ok"
   local linesProcessed = 0
   local startTime = os.clock()
   g.show('Find End Started')
   if scriptFileData then
      if scriptFileData.LOGFILE then
         logDiverted = divertLog(scriptFileData.LOGFILE)
      end
      comProcs.LogScript(segmentNo)
      if openOutFile() then
         local rule, seed, geo, hv, wv, newPop
         for key in pairs(m.linesNotDone) do
            keyPart = {}
            for word in string.gmatch(key, "[^:]+") do
               keyPart[#keyPart + 1] = word
            end
            if (#keyPart == 5) then
               rule = keyPart[1]
               geo = keyPart[2]
               wv =  tonumber(keyPart[3])
               hv = tonumber(keyPart[4])
               seed = keyPart[5]    

--               logFile:write("OldData key "..key..'\n')
               logFile:write("OldData "..m.linesNotDone[key][1]..","..m.linesNotDone[key][2]..","..m.linesNotDone[key][3]..","..m.linesNotDone[key][4]..'\n')
               maxOsc = tonumber(m.linesNotDone[key][2])+10
               minOsc = 1
               endGen = tonumber(m.linesNotDone[key][1])

               gr.doBuild(' SymCACP findEndVal ', wv, hv, seed, geo.."%50", rule)  -- w, h, seed, rule, format
               g.run(endGen)
               newPop = tonumber(g.getpop())
               if ( m.linesNotDone[key][3] ~= newPop ) then
                  m.noDiffs = m.noDiffs + 1
               end
               doFINDpopRes(m.outFile, rule, geo, wv, hv, seed, endGen, m.linesNotDone[key][2], newPop, m.linesNotDone[key][4])
               linesProcessed = linesProcessed + 1
               logFile:write("Lines Done ",linesProcessed,' Difs ',m.noDiffs,' Key ',key,' endGen ',endGen,", end type ",m.linesNotDone[key][4],'\n')
               event = g.getevent()
               if (event:find("^key") or event:find("^oclick"))  then
                  logFile:write("oscFoundPop stoped by user action\n")
                  res = 'killed'
                  break
               end
            else
               logFile:write("Short Key in data"..key.."\n")
            end            
            if res == 'killed' then break end
         end
         if m.outFile then
            m.outFile:close()
            m.outFile = nil
         end
         logFile:write("Total Line "..m.noLines.." Differance found "..m.noDiffs.." No Max Exceeded "..m.noMaxEx.."\n")
      else
        logFile:write('Data not loaded\n')
      end
      g.show('Finished')
   else
     logFile:write('No Script file Loaded\n')
   end
   local elapsed = os.clock()-startTime
   local elHrs = math.floor(elapsed/3600)
   local elMins = math.floor((elapsed-elHrs*3600)/60)
   local elSecs = (elapsed-elHrs*3600-elMins*60)   
   logFile:write(string.format("Finished Run Length in %2d Hrs %2d Mins %2.2f Secs\n", elHrs,elMins,elSecs  ))
end

return m
------------------------------------------------------------
